/**
 * \file: AautoLayerManager.h
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * <brief description>.
 * <detailed description>
 * \component: Android Auto - Prototype
 *
 * \author: Veeraiyan Chidambaram /RBEI/ECF3/ veeraiyan.chidambaram@in.bosch.com
 *
 *
 * \copyright (c) 2013 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 * \see <related items>
 *
 * \history
 *
 ***********************************************************************/

#ifndef AAUTO_LAYERMANAGER_H
#define AAUTO_LAYERMANAGER_H

#include <adit_logging.h>
#include <map>
#include <string>

#include <ilm/ilm_client.h>
#include <ilm/ilm_control.h>

#include "utils/IConfiguration.h"


namespace adit { namespace aauto {

typedef struct surfaceDimensions_t
{
    t_ilm_uint      srcWidth;
    t_ilm_uint      srcHeight;
    t_ilm_uint      destWidth;
    t_ilm_uint      destHeight;

} surfaceDimensions;

typedef struct mobileDeviceSettings_t
{
    t_ilm_surface       surfaceId;
    surfaceDimensions   size;
    int                 deviceIndex;

} mobileDeviceSettings;

class aautoLayerManager
{
public:
    aautoLayerManager(IDynamicConfiguration& inConfig);
    ~aautoLayerManager();

    // Server
    bool addMobileDevice(std::string inDeviceSerial);
    void deleteMobileDevice(std::string inDeviceSerial);
    void finalize();

    // onKeyEventDeviceSelection
    bool bringDeviceToFront(const int inDeviceIndex);

    // Server
    t_ilm_layer getLayerId() const;
    t_ilm_surface getSurfaceId(std::string inDeviceSerial) const;

    t_ilm_surface getTouchSurfaceId(std::string inDeviceSerial) const;

    // ilm callbacks to configure ilm surface
    static void ilmNotifyCB(ilmObjectType object, t_ilm_uint id, t_ilm_bool created, void *user_data);
#ifndef IMX_DEMO
    static void ilmSurfaceCB(t_ilm_uint id, struct ilmSurfaceProperties* sp, t_ilm_notification_mask mask);
#endif

protected:
    void configure_ilm_surface(t_ilm_uint id, t_ilm_uint width, t_ilm_uint height);

private:
    std::map<std::string, mobileDeviceSettings> mMobileDevices;
    pthread_mutex_t orderMutex;

    bool mIlmInit;
    bool mSharedSurface;
    t_ilm_display mDisplayId;
    t_ilm_layer mLayerId;
    t_ilm_surface mSurfaceId;
    std::string mActiveDevice;
    t_ilm_uint mResolutionWidth;
    t_ilm_uint mResolutionHeight;
    int32_t mMaxDevices;

    IDynamicConfiguration* mConfig;

    bool init();
    bool createLayer(const t_ilm_uint inSrcWidth, const t_ilm_uint inSrcHeight);
    bool getHighestResolution(t_ilm_display* outDisplayId, t_ilm_uint* outSrcWidth, t_ilm_uint* outSrcHeight);
    int getFreeDeviceIndex();

    void removeLayer();

    bool refreshZOrder(const std::string inDeviceSerial);

};
} } /* namespace adit { namespace aauto */

#endif /* AAUTO_LAYERMANAGER_H */
